function TOPO = init_angularity_matrix(SIZE)
global G_ANGULARITY_MATRIX;
global G_WALL_MATRIX;
G_WALL_MATRIX = zeros(SIZE);
define_arena_frame(SIZE);
add_wall(SIZE);
TOPO = G_ANGULARITY_MATRIX;

function define_arena_frame(SIZE)
global G_ANGULARITY_MATRIX;
G_ANGULARITY_MATRIX = zeros(SIZE);
%set the edges
G_ANGULARITY_MATRIX(1,:)=(0.65)^2*ones(1,SIZE);
G_ANGULARITY_MATRIX(SIZE,:)=(0.65)^2*ones(1,SIZE);
G_ANGULARITY_MATRIX(:,1)=(0.65)^2*ones(SIZE,1);
G_ANGULARITY_MATRIX(:,SIZE)=(0.65)^2*ones(SIZE,1);
G_WALL_MATRIX(1,:)=ones(1,SIZE);
G_WALL_MATRIX(SIZE,:)=ones(1,SIZE);
G_WALL_MATRIX(:,1)=ones(SIZE,1);
G_WALL_MATRIX(:,SIZE)=ones(SIZE,1);
%set the corners
G_ANGULARITY_MATRIX(1,1) = (0.75)^2;
G_ANGULARITY_MATRIX(1,SIZE) = (0.75)^2;
G_ANGULARITY_MATRIX(SIZE,1) = (0.75)^2;
G_ANGULARITY_MATRIX(SIZE,SIZE) = (0.75)^2;
G_ANGULARITY_MATRIX(1,1) = 1;
G_ANGULARITY_MATRIX(1,SIZE) = 1;
G_ANGULARITY_MATRIX(SIZE,1) = 1;
G_ANGULARITY_MATRIX(SIZE,SIZE) = 1;

function add_wall(SIZE)
global G_ANGULARITY_MATRIX;
G_ANGULARITY_MATRIX(SIZE/3,1:SIZE/3)=(0.65)^2;%*ones(SIZE,1);
G_WALL_MATRIX(SIZE/3,1:SIZE/3)=1;

