%declare all globals participating
global SIZE;
global BEGIN_POINT;
global ANGUL_MAT;
global KNOW_MAT;
%definition of the simulation length
NUMBER_OF_STEPS = SIZE^2;
CURRENT_LOCATION = BEGIN_POINT;
%for display purposes
comet_x_vector = zeros(1,NUMBER_OF_STEPS);
comet_y_vector = zeros(1,NUMBER_OF_STEPS);
%initialize once
NEXT_STEP = [0 0];
FEAR = zeros(SIZE);
DECISION_MAT = zeros(SIZE);
for  i = 1:NUMBER_OF_STEPS
   FEAR = compute_fear(SIZE,ANGUL_MAT,KNOW_MAT);
   CURIOSITY = compute_curiosity(SIZE,KNOW_MAT,CURRENT_LOCATION);
   DECISION_MAT = weighted_sum(FEAR,CURIOSITY);
   NEXT_STEP = decide_where_to_go(CURRENT_LOCATION,DECISION_MAT,SIZE);
   % update all kind of side effects fron the new step
   update_state(CURRENT_LOCATION, NEXT_STEP);
   CURRENT_LOCATION = NEXT_STEP;
   comet_x_vector(i) = NEXT_STEP(1);
   comet_y_vector(i) = NEXT_STEP(2);
%   if mod(i,200) == 0
%      comet(comet_x_vector(1:i),comet_y_vector(1:i));
%   end
end
comet(comet_x_vector,comet_y_vector);
% TODO: replace FEAR to DECISION_MAT
