function FEAR_MAT = fear()
global GLOBAL_ANGUL_FEAR_MAT;
if isempty(GLOBAL_ANGUL_FEAR_MAT)
   GLOBAL_ANGUL_FEAR_MAT = zeros(IN_SIZE);
   for m=1:IN_SIZE
      for n=1:IN_SIZE
         CELL_FEAR = compute_cell_fear(IN_SIZE,m,n,IN_TOPO(m,n));
         GLOBAL_ANGUL_FEAR_MAT = GLOBAL_ANGUL_FEAR_MAT + CELL_FEAR;
      end
   end
   % normalize the total field to range between 0-1.
   FILT=3*ones(IN_SIZE);
   FILT1=zeros(IN_SIZE);
   fear1=GLOBAL_ANGUL_FEAR_MAT;
   FI = round(IN_SIZE/8);
   TI = round(7*IN_SIZE/8);

   FILT1(FI:TI,FI:TI) = max(max(fear1));
   fear1 = fear1+FILT1;
   fear1 = fear1-min(min(fear1));
   fear1 = fear1./max(max(fear1));
   
   %GLOBAL_ANGUL_FEAR_MAT = GLOBAL_ANGUL_FEAR_MAT.*FILT;
   %GLOBAL_ANGUL_FEAR_MAT = GLOBAL_ANGUL_FEAR_MAT-min(min(GLOBAL_ANGUL_FEAR_MAT));
   %GLOBAL_ANGUL_FEAR_MAT = GLOBAL_ANGUL_FEAR_MAT./max(max(GLOBAL_ANGUL_FEAR_MAT));
   GLOBAL_ANGUL_FEAR_MAT = fear1;
end
% assign the global fear matrix to the output
ANGUL_FEAR_MAT  = GLOBAL_ANGUL_FEAR_MAT;

% END OF angul_fear_operator
% -----------------------------------------------------------------

% -------- compute_cell_fear -----------
function OUT_CELL_FEAR_MAT = compute_cell_fear(IN_SIZE,IN_M,IN_N,IN_TOPO_VALUE)
global DISTANCE_MAT;
global CELL_FEAR_AUX;
%in order to reuse calculations, we calculate ONLY once the relation
%of the "force"effect to the distance
if isempty(CELL_FEAR_AUX)
   CELL_FEAR_AUX = min((exp(1./(DISTANCE_MAT+1)))-1,1);
end   
% the matrix is initialized with the biggest values possible
% the distance matrix is layed over the cell matrix;
OUT_CELL_FEAR_MAT = CELL_FEAR_AUX(IN_SIZE-IN_M+1:2*IN_SIZE-IN_M,IN_SIZE-IN_N+1:2*IN_SIZE-IN_N);
OUT_CELL_FEAR_MAT = OUT_CELL_FEAR_MAT./(IN_TOPO_VALUE+1);

% END OF compute_cell_fear
% -----------------------------------------------------------------
