function NextStep = choose_best_neighbour(CurrentLocation,ForceField)
%create a siluette of zeros to calculate it well.
Size = get_world_size;
TempField = zeros(Size+2);
TempField(2:Size+1,2:Size+1) = ForceField;

%tempdecision_curr_loc is one less than the center of the process
%which returns to be of the value of the original location
temp_curr_loc = CurrentLocation;
M = temp_curr_loc(1);
N = temp_curr_loc(2);

%sum the 3x3 square of values around CURRENT_VALUE
WORK_AREA = TempField(M:M+2,N:N+2);

NextStep = DeterministicChoise(M,N,WORK_AREA);
%NextStep = RandomChoise(M,N,WORK_AREA);



function OutStep = RandomChoise(M,N,WORK_AREA)
OutStep = [M N];
TOTAL_SUM = sum(sum(WORK_AREA));
% get a random number in the range 0 - TOTAL_SUM
random_factor = 0;
while random_factor == 0
   random_factor = rand;
end
random_value = TOTAL_SUM*random_factor;
% find the value that defines the range,
% where the random value is in.
TEMP_SUM = 0;
FINISHED_FLAG = 0;
for i = 1:3
   for j = 1:3
      TEMP_SUM = TEMP_SUM + WORK_AREA(i,j);
      if random_value <= TEMP_SUM
         OutStep = [M+i-2 N+j-2];
         FINISHED_FLAG = 1;
         break;
      end
   end
   if FINISHED_FLAG == 1
      break;
   end
end
% if at least one of the coordinates equals zero
if OutStep(1)*OutStep(2) == 0
   A = 'Invalide location'
end

function OutStep = DeterministicChoise(M,N,WORK_AREA)
MaxVal= -1;
OutStep = [M-1 N-1];
for i = 1:3
  	for j = 1:3
        if (MaxVal < WORK_AREA(i,j))
            MaxVal = WORK_AREA(i,j);
	        	OutStep = [M+i-2 N+j-2];
        end
  	end
end
