function OUT_KNOW_CURIOSITY = knowledge_curiosity_operator(IN_SIZE,IN_KNOWLEDGE,IN_CURR_LOC)
% applying the distance on the emphasized knowledge matrix,
% according to the input location
TEMP = applyDistance(IN_CURR_LOC,IN_KNOWLEDGE.^2);
% normalizing the result into 0-1 range
normalize(TEMP);
% reversing the result (still in the range 0-1)
OUT_KNOW_CURIOSITY = 1-TEMP;

% *************** normalize ****************
function OUT_MAT = normalize(IN_MAT)
OUT_MAT = IN_MAT-min(min(IN_MAT));
OUT_MAT = OUT_MAT./max(max(OUT_MAT));

% *************** applyDistance ****************
fuction OUT_K_C = applyDistance(IN_CURR_LOC,IN_CURIOSITY)
global DISTANCE_MAT;
IN_M = IN_CURIOSITY(1);
IN_N = IN_CURIOSITY(2);
%inserting the out matrix the correct distance values
OUT_K_C = DISTANCE_MAT(IN_SIZE-IN_M+1:2*IN_SIZE-IN_M,IN_SIZE-IN_N+1:2*IN_SIZE-IN_N);
%multoplying the curiosity values with correct distances
OUT_K_C = IN_CURIOSITY.*OUT_K_C;
