% ---------- update_state ----------------
function update_state(PREV_LOCATION, NEW_LOCATION)
%declare all globals participating
global SIZE;
global KNOW_MAT;
global EXPLORATION_MODE;

M = NEW_LOCATION(1);
N = NEW_LOCATION(2);
KNOW_MAT(M,N) = KNOW_MAT(M,N) + 1;

EXPLORATION_MODE = UpdateCharger(PREV_LOCATION,NEW_LOCATION);
%% 23.10.2000 : override the update charger for testing
%if (KNOW_MAT(M,N) > 10)
%   EXPLORATION_MODE = 'E';
%else
%   EXPLORATION_MODE = 'R';
%end

% ---------- UpdateCharger ----------------
function ExplorationMode = UpdateCharger(PREV_LOCATION, CURRENT_LOCATION);

global CHARGER_VALUE;
global CHARGER_THRESHOLD;
global KNOW_MAT;

Curr_Mode = Exploration_Mode;
Change_Location_Flag = (PREV_LOCATION ~= CURRENT_LOCATION);

if (Curr_Mode == 'E')
   if (Change_Location_Flag)
		CHARGER_VALUE = CHARGER_VALUE - 5;%Delta(KNOW_MAT, PREV_LOCATION, CURRENT_LOCATION);      
   end
end
   
if (Curr_Mode == 'R') 
   if (~Change_Location_Flag)
   	CHARGER_VALUE = CHARGER_VALUE + 4;
		Curr_Mode = Exploration_Mode;
		if (Curr_Mode == 'E')
      	Apply_Mode_Change_2_Charger(CURRENT_LOCATION, 'E');
      end
   end
end

ExplorationMode = Exploration_Mode;
   
% ---------- Exploration_Mode ----------------
% returns the exploration mode as a function 
% of the charger state.
   
function Ret = Exploration_Mode
global CHARGER_VALUE;
global CHARGER_THRESHOLD;
if (CHARGER_VALUE <= CHARGER_THRESHOLD)
   Ret = 'R';
else
   Ret = 'E';
end

   
% ---------- Apply_Mode_Change_2_Charger ----------------
function Apply_Mode_Change_2_Charger(IN_CURRENT_LOCATION, Mode)
global KNOW_MAT;
global CHARGER_VALUE;
M = IN_CURRENT_LOCATION(1);
N = IN_CURRENT_LOCATION(2);
CHARGER_VALUE = CHARGER_VALUE + 10;%KNOW_MAT(M,N);

% ---------- Delta ----------------
function Ret = Delta(IN_MAT, IN_PREV_LOCATION, IN_CURRENT_LOCATION)
global CHARGER_VALUE;
MC = IN_CURRENT_LOCATION(1);
NC = IN_CURRENT_LOCATION(2);
MP = IN_PREV_LOCATION(1);
NP = IN_PREV_LOCATION(2);
Ret = IN_MAT(MC,NC)-IN_MAT(MP,NP);
