function [tr,sec,cur,trc_x,trc_y]=RunSim(step_num,start_x,start_y)
% run the simulation.
% in: number of steps, initial position (x and y)
% out:
% tr - a matrix, each position's value is the number of steps the rat spent in that position
% sec, cur - the security and curiosity factors values.
% trc_x, trc_y - the x and y coordinates of the rat's motion throughout the simulation

% the vector of the positions
global TRACE;
% external security matrix
global EXT_SEC;
% external curiosity matrix
global EXT_CUR;
% internal security factor
global SEC_FACTOR;
% internal curiosity factor
global CUR_FACTOR;
% memory matrix
global MEM;
% final matrix
global FINAL_MAT;
% matrix size
global MAT_SIZE;
% step counter
global COUNT;
% consolidated matrices
global CONS_CUR;
global CONS_SEC;

% initialize constants and matrices
MAT_SIZE=40;
EXT_SEC=0.20*(MakeSecMat+1)+0.30*(AddMatrix+1)+ExtraMatrix;
EXT_SEC=EXT_SEC*0.5;
EXT_CUR=0.85*EXT_SEC;
SEC_FACTOR=zeros(40);
SEC_FACTOR=SEC_FACTOR+0.5;
CUR_FACTOR=zeros(40);
MEM=zeros(40);
COUNT=1;
TRACE=zeros(2,step_num);
TRACE(1,1)=start_x;
TRACE(2,1)=start_y;

% for debugging:
% track is the matrix used for tracking. each matrix element counts the number of steps the rat
% visited it
track=zeros(40);
% now the vectors which hold the internal factors values
secvec=zeros(1,step_num);
secvec(1)=SEC_FACTOR(1,1);
curvec=zeros(1,step_num);
curvec(1)=CUR_FACTOR(1,1);

% MAIN SIMULATION LOOP!!
for step=1:step_num
   % calculate final matrix
   FinalMatrixCalc;
   % set next position
   [next_x,next_y]=SelectNewPos(TRACE(1,COUNT),TRACE(2,COUNT));
   COUNT=COUNT+1;
   % record the track coordinates and matrix
   TRACE(1,COUNT)=next_x;
   TRACE(2,COUNT)=next_y;
   track(next_x,next_y)=track(next_x,next_y)+1;
   % update variables
   MemCalc;
   SecFactorCalc;
   CurFactorCalc;
   secvec(step)=SEC_FACTOR(1,1);
   curvec(step)=CUR_FACTOR(1,1);
end
% set out parameters
tr=track;
cur=curvec;
sec=secvec;
trc_x=TRACE(1,:);
trc_y=TRACE(2,:);
