function [next_x,next_y] = SelectNewPos(x,y)
% select one of the 9 (or less) positions adjacent to x,y, according to the FINAL_MAT values.
% multiply the 9 adjacent values by a random factor, and then take the maximum
global MAT_SIZE;
global FINAL_MAT;
% add lines of -infinity around the FINAL_MAT
a=zeros(1,MAT_SIZE);
a=a-inf;
mat=[a;FINAL_MAT;a];
b=zeros(MAT_SIZE+2,1);
b=b-inf;
mat=[b,mat,b];
% now collect the elements:
temp_x=x+1;
temp_y=y+1;
vec = zeros(1,9);
m=1;
for k=temp_x-1:1:temp_x+1
   for l=temp_y-1:1:temp_y+1
      % multiply by random
      vec(m)=mat(k,l)*(100+rand);
      m=m+1;
   end
end
% find max
index=find(vec==max(vec));
index=index(1);
% translate to direction
switch index
case 1,
   next_x=x-1;
   next_y=y-1;
   return;
case 2,
   next_x=x-1;
   next_y=y;
   return;
case 3,
   next_x=x-1;
   next_y=y+1;
   return;
case 4,
   next_x=x;
   next_y=y-1;
   return;
case 5,
   next_x=x;
   next_y=y;
   return;
case 6,
   next_x=x;
   next_y=y+1;
   return;
case 7,
   next_x=x+1;
   next_y=y-1;
   return;
case 8,
   next_x=x+1;
   next_y=y;
   return;
case 9,
   next_x=x+1;
   next_y=y+1;
   return;
otherwise,
   next_x=x;
   next_y=y;
   return;
end



      
      
      
      
         